<!DOCTYPE html>
<html>
<head>
    <title>Motor Run Time Calculator</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            flex-direction: column;
            min-height: 100vh;
            background-color: #f4f4f4;
            width: 100%;
            box-sizing: border-box;
        }
        .container {
            background: white;
            padding: 15px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            max-width: 100%;
            width: 95%;
            box-sizing: border-box;
        }
        input[type="number"], input[type="submit"] {
            width: 100%;
            padding: 8px;
            margin: 4px 0;
            border: 1px solid #ccc;
            border-radius: 5px;
            box-sizing: border-box;
        }
        input[type="submit"] {
            background-color: #28a745;
            color: white;
            font-weight: bold;
            cursor: pointer;
        }
        input[type="submit"]:hover {
            background-color: #218838;
        }
        .blink {
            font-size: 20px;
            font-weight: bold;
            color: red;
            animation: blink 1s infinite;
            text-align: center;
        }
        @keyframes blink {
            50% { opacity: 0; }
        }
        .green-text {
            font-size: 18px;
            font-weight: bold;
            color: green;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Motor Run Time Calculator</h2>
        <form method="post">
            <label for="plants">Number of Plants:</label>
            <input type="number" id="plants" name="plants" value="<?php echo isset($_POST['plants']) ? $_POST['plants'] : ''; ?>" required>
            
            <label for="water_ml">Water per Plant (ml):</label>
            <input type="number" id="water_ml" name="water_ml" value="<?php echo isset($_POST['water_ml']) ? $_POST['water_ml'] : ''; ?>" required>
            
            <label for="flow_rate">Pump Flow Rate (liters per minute):</label>
            <input type="number" id="flow_rate" name="flow_rate" value="<?php echo isset($_POST['flow_rate']) ? $_POST['flow_rate'] : ''; ?>" required>
            
            <input type="submit" name="calculate" value="Calculate">
        </form>
        
        <?php
        if ($_SERVER["REQUEST_METHOD"] == "POST") {
            $plants = $_POST['plants'];
            $water_ml = $_POST['water_ml'];
            $flow_rate = $_POST['flow_rate'];
            
            if ($plants > 0 && $water_ml > 0 && $flow_rate > 0) {
                $run_time = ($plants * $water_ml) / (1000 * $flow_rate);
                $total_water = ($plants * $water_ml) / 1000; // Convert ml to liters
                echo "<h3 class='blink'>Motor Run Time: " . round($run_time) . " minutes</h3>";
                echo "<h3 class='green-text'>Total Water Needed: " . $total_water . " liters</h3>";
            } else {
                echo "<h3>Please enter valid positive values.</h3>";
            }
        }
        ?>
    </div>
</body>
</html>
